/**
 * \file: dipo_macros.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: CarPlay macro utils
 *
 * \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see
 *
 * \history
 *
 ***********************************************************************/

#ifndef DIPO_MACROS_H
#define DIPO_MACROS_H

#ifndef nullptr
#define nullptr 0
#define _dipo_nullptr
#endif

/* coding rule exception: exit() is used to quit after FATAL errors */
#define dipo_exit_on_null(ptr) do { if (ptr == nullptr) \
    { fprintf(stderr, "null ptr @ %s: " #ptr "\n", __FUNCTION__); exit(1); } } while (0)
#define dipo_exit_on_invalid_argument(cond) do { if (cond) \
    { fprintf(stderr, "invalid argument @ %s: " #cond "\n", __FUNCTION__); exit(1); } } while (0)
#define dipo_return_on_invalid_argument(context, cond) do { if (cond) \
    { fprintf(stderr, "invalid argument @ %s: " #cond "\n", __FUNCTION__); return; } } while (0)
#define dipo_return_value_on_null(context, ptr, val) do { if (ptr == nullptr ) \
    { fprintf(stderr, "null ptr @ %s: " #ptr "\n", __FUNCTION__); } } while (0)
#define dipo_return_value_on_invalid_argument(context, cond, val) do { if (cond) \
    { fprintf(stderr, "invalid argument @ %s: " #cond "\n", __FUNCTION__); return val; } } while (0)

#define dipo_safe_delete(ptr) do { if (ptr != nullptr) \
    { delete ptr; ptr = nullptr; } } while (0)
#define dipo_safe_delete_array(ptr) do { if (ptr != nullptr) \
    { delete[] ptr; ptr = nullptr; } } while (0)
#define dipo_safe_call(call, ptr) do { if (ptr != nullptr) \
    { call(ptr); ptr = nullptr; } } while (0)

#ifdef _dipo_nullptr
#undef nullptr
#endif

#endif /* DIPO_MACROS_H */
